// Any questions? E-mail me at Xerios@gmail.com
// Have fun peeking at my code, it's damn messy alright =P
// Made manefest v2 compliant by Alvin Chong (iron2000)

var settings = JSON.parse(localStorage.settings);

var pageNo = 0;
var popupLoaded = false;

var filterTimeOut;
var filterStrings;
var filterRegEx;

function createLink(id, url, pgTitle) {
  var link = document.createElement('a');
  link.href="";
  link.onclick = function(e){
	//if middle mouse button click
	if (e.button == 1){ 
		e.preventDefault();
		e.stopPropagation();
		showUrl(id,false); 
		loadText();
	}else{ 
		showUrl(id,true);
		loadText();
	}
  };
  if(settings.tooltipText){
	link.href = url;
	link.title = pgTitle;
  }else{
	link.title = url;
  }
  return link;
}

var nowtime,currentTime;
var content;

function loadText(){

	content = document.getElementById("content");
	// Don't popup if there's nothing to show
	var n = localStorage.closedTabCount;
	
	nowtime = new Date();
	
	if (popupLoaded==false){
		var lastOpened = parseInt(localStorage.lastOpened,10);
		//detect double-click
		if (lastOpened>0 && !settings.disableDClick){
			var timeDiff =  nowtime.getTime() - lastOpened;
			if (timeDiff<600){ 
				getLastTab();
				window.close();
				return;
			}
		}
		currentTime = nowtime.getTime(); 
		localStorage.lastOpened=currentTime;
	}
	
	popupLoaded=false;

	if (settings.menuTop == true) content = document.getElementById("content2");
	if (settings.boldFont == true) content.className+=" bold";

	content.innerHTML="<center><b>"+chrome.i18n.getMessage("popup_loadMsg")+"</b></center>";
		
	if (parseInt(n,10) == 0){
		//console.log("No tabs");
		document.getElementById("tailenders").className="tailendersHide";
		document.getElementById("prev").style.visibility="hidden";
		document.getElementById("next").style.visibility="hidden";
		content.innerHTML=chrome.i18n.getMessage("popup_noTabsMsg");
	}else{
		//console.log("to LoadPage..");
		loadPage();
	}
	
	if(settings.showSearch == false && settings.showClear == false && settings.numLimit == settings.numItems) { document.getElementById("controls").style.display="none"; } else{
	//console.log("Controls show..");

		if (settings.showSearch == true){ 
			document.getElementById("searchQ").focus();
		}else {
			document.getElementById("searchQ").style.display="none";
			document.getElementById("searchholder").style.width="175px";
		}
		if (settings.showClear == true) {
			document.getElementById("clr").style.display="inline";
			document.getElementById("clrholder").style.width="64px";
			if(document.getElementById("tailenders").className=="tailendersHide"){
				document.getElementById("searchQ").style.width="210px";
			}else{
				document.getElementById("searchQ").style.width="150px";
			}
		} else {
			document.getElementById("clr").style.display="none";
			if (settings.showSearch == true) {
				document.getElementById("clrholder").style.width="0px";
			} else {
				document.getElementById("clrholder").style.width="64px";
			}
			if(document.getElementById("tailenders").className=="tailendersHide"){
				document.getElementById("searchQ").style.width="272px";
			}else{
				document.getElementById("searchQ").style.width="212px";
			}
		}

		if (filterStrings!=null) {
			document.getElementById("tailenders").className="tailendersShow";
			document.getElementById("delete").style.display="inline";
			document.getElementById("prev").style.display="none";
			document.getElementById("next").style.display="none";
			document.getElementById("clr").style.display="none";
			document.getElementById("clrholder").style.width="0px";
			document.getElementById("searchQ").style.width="210px";
		}else{
			document.getElementById("delete").style.display="none";
			document.getElementById("prev").style.display="inline";
			document.getElementById("next").style.display="inline";
		}
	
	}
}

function getLastTab(){
	//console.log("LAST TAB");
	var min_limit = localStorage.minimumTabInc;
	for (var i = localStorage.uniqueTabInc - 1; i>=min_limit ; i--){
		if (localStorage["ClosedTab-"+i]){
			showUrl(i,true);
			return;
		}
	}
}

function loadPage(){
	
	//console.log("LOAD PAGE");
	if (!popupLoaded) {
		content.innerHTML="";
		popupLoaded=true;
	}

	var items_to_display=settings.numItems;
	if (filterStrings!=null) items_to_display=1000;


	nowtime = new Date();
	currentTime = nowtime.getTime(); 
	//console.log("LOAD PAGE.");
	var min_limit = localStorage.minimumTabInc;

	for (var j = 0, i = localStorage.uniqueTabInc - 1; i>=0 && j<pageNo*items_to_display; i--) if (localStorage["ClosedTab-"+i]) j++;

	for (var j = 0; i>=min_limit && j<items_to_display; i--){
		var closedTab = localStorage["ClosedTab-"+i];
		if (closedTab){
			if (filterStrings==null || (filterStrings!=null && closedTab.multiFind(filterStrings))){
				//setTimeout(ShowEntry, 0,i,closedTab);
				ShowEntry(i,closedTab);
				j++;
			}
		}
	}

	if (filterStrings==null) {
		//console.log("No search");
		document.getElementById("tailenders").className="tailendersHide";
		document.getElementById("prev").style.visibility="hidden";
		document.getElementById("next").style.visibility="hidden";
		if (pageNo > 0) {
		//console.log("tailenders4");
		document.getElementById("tailenders").className="tailendersShow";
		document.getElementById("prev").style.visibility="visible";
		}
		if (localStorage.closedTabCount > (pageNo+1) * settings.numItems) {
		//console.log("tailenders5");
		document.getElementById("tailenders").className="tailendersShow";
		document.getElementById("next").style.visibility="visible";
		}
	}else{
		if (j==0) content.innerHTML="<center><b>"+chrome.i18n.getMessage("popup_noSearchResult")+" \'"+unescape(filterStrings.join(" "))+"\'</b></center>";
	}
	/*
	var nowtime = new Date();
	var end = nowtime.getTime();
	var took = (end - currentTime);

	var textdiv = document.createElement('div');
	textdiv.innerHTML = "This took : " + took + " ms"; 
	content.appendChild(textdiv);*/
}
function ShowEntry(i,closedTab) {

	if (!popupLoaded) return;
	
	var split = closedTab.split("%%");
	var tabTime = split[1];
	var tabUrl = split[2];
	var tabTitle = split[3];

	var text_link = createLink(i, tabUrl, tabTitle);
	var html;

	html="<img src=\"chrome://favicon/"+tabUrl+"\" alt=\""+tabUrl+"\" width=16 height=16>"; 

	if (filterStrings!=null) tabTitle=tabTitle.multiReplace(filterStrings);
	
	html+="<div";
	if (settings.numLines!=0 && !isNaN(settings.numLines) && filterStrings==null) html+=" class=\"maxh"+settings.numLines+"\"";
	html+="> "+ tabTitle +"</div>";
	
	if (settings.showTime){
		var timeTextz;

		var difference = currentTime - tabTime; 
		var hoursDifference = Math.floor(difference/1000/60/60); 
		difference = difference - hoursDifference*1000*60*60; 
		var minutesDifference = Math.floor(difference/1000/60); 
		difference = difference - minutesDifference*1000*60; 
		var secondsDifference = Math.floor(difference/1000); 
		if ( hoursDifference < 1 &&  minutesDifference < 1 &&secondsDifference < 60) timeTextz = '<b>'+ secondsDifference + 's</b> ago'; 
		else if (hoursDifference < 1) timeTextz ='<b>'+ minutesDifference + ' min</b> ago'; 
		else if (hoursDifference < 4) timeTextz= '<b>' + hoursDifference + 'h ' + minutesDifference + 'min</b>'; 
		else if (hoursDifference < 24) timeTextz='<b>' + hoursDifference + 'h</b> ago'; 
		else {
			var daysDiff=Math.floor(hoursDifference/24);
			timeTextz='<b>' + daysDiff + ' days</b> '; 
		}
		html+="<span>"+timeTextz+"</span>";
	}
	
	text_link.innerHTML=html;
	content.appendChild(text_link);
	//pause(10);
}
/*
function pause(millis) 
{
        var date = new Date();
        var curDate = null;
 
        do { curDate = new Date(); } 
        while(curDate-date < millis)
}
*/

function searchFor(string) {
	string = string.replace(/(\%)/g, "%25");
	string = string.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	string = stripVowelAccent(string);

	if ((filterStrings==null && string=="") || (filterStrings!=null && string==filterStrings.join(" "))) return;

	if (string==""){
		pageNo=0;
		filterStrings = null;
	}else{
		pageNo=0;
		//for(var i=0; i < filterStrings.length-1; i=i+1) { 
		string=string.toLowerCase();
		filterStrings = string.split(" "); 
	}
	clearTimeout(filterTimeOut);
	filterTimeOut=setTimeout(loadText,200);
}
function next() {
	if (localStorage.closedTabCount > (pageNo+1) * settings.numItems) pageNo++;
	loadText();
}

function prev() {
	if (pageNo > 0) pageNo--;
	loadText();
}

function reset(){
	if (document.getElementById("searchQ").value!=""){
		document.getElementById("searchQ").value="";
		searchFor("");
	}else{
		resetData();
		pageNo = 0;
		window.close();
	}
}

function deleteFoundTabs(){
if (filterStrings==null) return;
	  for (i = localStorage.uniqueTabInc - 1; i>=0; i--){
		var closedTab = localStorage["ClosedTab-"+i];
		if (closedTab){
			if (filterStrings!=null && closedTab.multiFind(filterStrings)){
				delete localStorage["ClosedTab-"+i];
				localStorage.closedTabCount --;
			}
		}
	}
	loadText();
	setBadge();
}

function stripVowelAccent(str)
{
	var rExps=[ /[\xC0-\xC2]/g, /[\xE0-\xE2]/g,
		/[\xC8-\xCA]/g, /[\xE8-\xEB]/g,
		/[\xCC-\xCE]/g, /[\xEC-\xEE]/g,
		/[\xD2-\xD4]/g, /[\xF2-\xF4]/g,
		/[\xD9-\xDB]/g, /[\xF9-\xFB]/g ];

	var repChar=['A','a','E','e','I','i','O','o','U','u'];

	for(var i=0, j=rExps.length; i<j; ++i)
		str=str.replace(rExps[i],repChar[i]);

	return str;
}

String.prototype.multiFind = function ( strings ) {
//console.log("this-"+this);
	var str = this, i;
	str = stripVowelAccent(str);
	str = str.toLowerCase();
	if(settings.searchMode!=3){
		var splitStr = str.split("%%");
		if(settings.searchMode==1) str = splitStr[3];
		if(settings.searchMode==2) str = splitStr[2];
	}
	var foundAmount=0;
	for (i = 0, j = strings.length; i < j; i++ ) {
	//console.log("str-"+str+"||strings[i]-"+strings[i]);
		if (str.indexOf(strings[i])!= -1) foundAmount++;
	}
	return (foundAmount==strings.length);
};
String.prototype.multiReplace = function ( strings ) {
	var str_real = this, i;
	var str = str_real;
	str = stripVowelAccent(str);
	str = str.toLowerCase();
	var position=-1;
	for (i = 0, j = strings.length; i < j; i++ ) {
		position = str.indexOf(strings[i]);
		if (position!= -1) {
			str_real = str_real.substr(0,position) + "<u>" + str_real.substr(position, strings[i].length) + "</u>" + str_real.substr(position + strings[i].length); 
			str = stripVowelAccent(str_real).toLowerCase();
		}
		//str = str.replace(new RegExp('(' + strings[i] + ')','gi'), replaceBy);
	}
	return str_real;
};

//keyboard navigation
var selLink = -1;
document.onkeydown = function(evt) {
    evt = evt || window.event;
	//left right
	if (evt.keyCode == 37||evt.keyCode == 39) { 
		if (evt.keyCode == 37) { 
           prev();
        }
        if (evt.keyCode == 39) { 
           next();
        }
	}
	//up down
	else if (evt.keyCode == 38||evt.keyCode == 40) {
        if (evt.keyCode == 38) { 
           if(selLink>0) selLink--;
		   else selLink=(document.links.length-1);
        }
        if (evt.keyCode == 40) { 
           if(selLink<(document.links.length-1)) selLink++;
		   else selLink=(0);
        }
		document.links[selLink].focus();
	}
	else {
		document.getElementById('searchQ').focus();
	}
};

//populate popup and bind functions to buttons on popup load
document.addEventListener('DOMContentLoaded', function () {

loadText();

document.getElementById('clr').addEventListener('click',reset);
document.getElementById('clr').title = chrome.i18n.getMessage("popup_clrbtn_tooltip");
document.getElementById('clr').innerHTML = chrome.i18n.getMessage("popup_clrbtn");
document.getElementById('searchQ').addEventListener('keyup',function(){
 searchFor(document.getElementById('searchQ').value);
});
document.getElementById('searchQ').title = chrome.i18n.getMessage("popup_search_tooltip");
document.getElementById('delete').addEventListener('click',deleteFoundTabs);
document.getElementById('delete').title = chrome.i18n.getMessage("popup_delbtn_tooltip");
document.getElementById('delete').innerHTML = chrome.i18n.getMessage("popup_delbtn");
document.getElementById('prev').addEventListener('click',prev);
document.getElementById('prev').title = chrome.i18n.getMessage("popup_prvbtn_tooltip");
document.getElementById('next').addEventListener('click',next);
document.getElementById('next').title = chrome.i18n.getMessage("popup_nxtbtn_tooltip");

});